/*
 * $Id: textproc.C,v 1.10 1994/07/16 00:04:53 asf Exp $
 */


/*
    This file is part of Addventure
    Copyright (C) 1994  Allen S. Firstenberg
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <post-query.H>

#define MAX_ENTRIES 100

/***************************************************************************/

int create_file( int room_id, char *text ){
  /*
   * Save the file
   */

  char fname[80];
  FILE *outfile;

  sprintf( fname,
          "%s/%d.html",
          ABSFILEPATH, room_id );
  umask( UMASK );  // Make the files rw-r--r-- or rw-rw-r--
  outfile = fopen( fname, "w" );
  fprintf( outfile, "<title>Addventure room %d</title>\n", room_id );
  fprintf( outfile, "<h1>Addventure room %d</h1>\n", room_id );
  fprintf( outfile, "%s<p>\n", text );
  fclose( outfile );

  return 1;  // Assume success for now
}

/***************************************************************************/

int reply_user( int room_id, int num_options ){
  /*
   * Reply to the user
   */

  int x;

  printf("Content-type: text/html%c%c",10,10);

  printf( "<title>Enter options for room %d</title>\n", room_id );
  printf( "<h1>Enter options for room %d</h1>\n", room_id );

  printf( "<form method=POST action=\"http:%s/optproc\">\n", BINPATH );
  
  for( x=0; x<num_options; x++ ){
    printf( "<input name=\"option%d\"><p>", x );
  }

  printf( "You may sign the room if you wish:" );
  printf( "<input name=\"signature\"><p>\n" );

  printf( "<input type=submit value=\"Accept.\"><p>" );

  printf( "<hr>Ignore anything below this line.<p>\n" );
  printf( "<input type=hidden name=\"ID\" value=\"%d\"><p>\n", room_id );
  printf( "<input type=hidden name=\"numoptions\" value=\"%d\"><p>\n", num_options );
  
  printf( "</form>" );
}
    
/***************************************************************************/

main(int argc, char *argv[]) {
    int room_id;
    char *text;
    int num_options;

    /*
     * Get all the values into the query object
     */
    PostQuery query( MAX_ENTRIES );

    /*
     * Error handling.
     */
    if( !query.valid() ){
      printf("Content-type: text/html%c%c",10,10);
      printf( "An error has occurred.  Your reply was not valid.\n" );
      exit(1);
    }

    /*
     * Get just the values we want
     */
    room_id     = atoi( query.lookup( "ID" ) );
    text        = query.lookup( "text" );
    num_options = atoi( query.lookup( "numoptions" ) );

    if( num_options > 0 ){
      // Create the reoom and reply
      create_file( room_id, text );
      reply_user( room_id, num_options );
    } else {
      // Reply with an error
      printf("Content-type: text/html%c%c",10,10);
      printf( "I'm sorry, but you need to indicate how many options you " );
      printf( "wish to provide.<p>\n" );
    }
}

/*
 * $Log: textproc.C,v $
 * Revision 1.10  1994/07/16  00:04:53  asf
 * Added umask() to set file permissions.
 *
 * Revision 1.9  1994/07/10  10:36:12  asf
 * Relocated the create_file() and reply_user() operations into their
 * own functions.
 * Added checking for 0 options (usually indicitive of the person not filling
 * the data in) and returns an error.
 *
 * Revision 1.8  1994/07/10  10:17:25  asf
 * Removed debugging statements
 *
 * Revision 1.7  1994/06/05  20:17:31  asf
 * Added signature field.
 *
 * Revision 1.6  1994/06/05  19:37:56  asf
 * Cleaned up option entry form, putting the hidden fields below a line.
 *
 * Revision 1.5  1994/06/05  09:22:16  asf
 * Added GPL
 *
 * Revision 1.4  1994/06/04  20:35:26  asf
 * Added/used defines for the file and bin paths.
 *
 * Revision 1.3  1994/05/28  12:42:34  asf
 * Converted to use the cgi-query library.
 *
 * Revision 1.2  1994/05/28  12:27:32  asf
 * Added Id and Log.
 *
 */
