/*
 * $Id: optproc.C,v 1.10 1994/07/16 00:04:45 asf Exp $
 */

/*
    This file is part of Addventure
    Copyright (C) 1994  Allen S. Firstenberg
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include <post-query.H>

#include "makeroom.H"

#define MAX_ENTRIES 100

/***************************************************************************/

main(int argc, char *argv[]) {
    register int x, co;    /* Generic counter */
    int cl;

    int room_id;
    int num_options;

    int new_room_id;

    char fname[100];
    FILE *outfile;

    char roomname[100];
    FILE *roomfile;

    char optionlabel[20];

    char *signature;

    /*
     * Get all the values into the query object
     */
    PostQuery query( MAX_ENTRIES );

    /*
     * Error handling.
     */
    if( !query.valid() ){
      printf("Content-type: text/html%c%c",10,10);
      printf( "An error has occurred.  Your reply was not valid.\n" );
      exit(1);
    }

    /*
     * Get the values we want
     */
    room_id     = atoi( query.lookup( "ID" ) );
    num_options = atoi( query.lookup( "numoptions" ) );

    /*
     * Get the next room number we are creating, and update that file
     */
    sprintf( roomname, "%s/next_room", ABSFILEPATH );
    umask( UMASK );  // Make the files rw-r--r-- or rw-rw-r--
    roomfile = fopen( roomname, "r" );
    fscanf( roomfile, "%d", &new_room_id );
    fclose( roomfile );
    umask( UMASK );  // Make the files rw-r--r-- or rw-rw-r--
    roomfile = fopen( roomname, "w" );
    fprintf( roomfile, "%d\n", new_room_id + num_options );
    fclose( roomfile );

    /*
     * Save the file, appending to the text we already had.
     */
    sprintf( fname,
             "%s/%d.html",
             ABSFILEPATH, room_id );
    umask( UMASK );  // Make the files rw-r--r-- or rw-rw-r--
    outfile = fopen( fname, "a" );
    for( co=0; co<num_options; co++ ){
      fprintf( outfile,
               "<a href=\"http:%s/%d.html\">",
               RELFILEPATH, new_room_id + co );

      sprintf( optionlabel, "option%d", co );
      fprintf( outfile, "%s", query.lookup( optionlabel ) );

      fprintf( outfile, "</a><p>\n" );
      make_room( new_room_id +  co, room_id );
    }

    /*
     * Put on a signature if there is one
     */
    signature = query.lookup( "signature" );
    if( signature ){
      // This was in the form
      if( signature[0] ){
        // There was a value entered

        fprintf( outfile, "<hr><ADDRESS>%s</ADDRESS>\n", signature );
      }
    }
    
    fclose( outfile );

    /*
     * Reply to the user
     */
    // Reply with a link
    // The page is the same one as the original form, so try to force
    //  it to reload the page by making the URL slightly different, but
    //  still perfectly legal.
    printf("Content-type: text/html%c%c",10,10);
    printf( "<title>Room %d completed</title>\n", room_id );
    printf( "<h1>Room %d completed</h1>\n", room_id );

    printf( "Room completed.  Ready for " );
    printf( "<a href=\"http:%s/%d.html?\">",
            RELFILEPATH, room_id );
    printf( "entry</a>\n" );
}

/*
 * $Log: optproc.C,v $
 * Revision 1.10  1994/07/16  00:04:45  asf
 * Added umask() to set file permissions.
 *
 * Revision 1.9  1994/07/13  19:51:26  asf
 * Sending the current room number to the make_room() function.
 *
 * Revision 1.8  1994/07/12  19:14:40  asf
 * Moved the Content-type reply a little, since It was possible that a Location
 * reply could have been returned.  (This didn't work very well in tests.)
 *
 * Added some comments to the reply code.
 * Added a ? after the URL that is to be linked to.  Since the page being
 * linked to used to contain the form, and now contains the actual room,
 * browsers that do caching might show the old page instead of the new one.
 * The question mark makes it a different URL and might trick the browser,
 * and doesn't seem to affect the Web server (at least not NCSA 1.3).
 *
 * Revision 1.7  1994/06/05  20:17:17  asf
 * Added signatures.
 *
 * Revision 1.6  1994/06/05  09:21:45  asf
 * Added GPL
 *
 * Revision 1.5  1994/06/04  22:26:09  asf
 * Broke out make_room() into its own file.
 *
 * Revision 1.4  1994/06/04  20:34:59  asf
 * Added/used defines for the file and bin paths.
 *
 * Revision 1.3  1994/05/28  13:00:45  asf
 * Converted to use the cgi-query library
 *
 * Revision 1.2  1994/05/28  12:28:30  asf
 * Added Id and Log.
 *
 */
