/*
 * $Id: makeroom.C,v 1.5 1994/07/16 00:04:23 asf Exp $
 */

/*
    This file is part of Addventure
    Copyright (C) 1994  Allen S. Firstenberg
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "makeroom.H"

/***************************************************************************/

void make_room( int room_no, int parent_room ){
  FILE *outfile;
  char filename[100];

  sprintf( filename, "%s/%d.html", ABSFILEPATH, room_no );
  umask( UMASK );  // Make the files rw-r--r-- or rw-rw-r--
  outfile = fopen( filename, "w" );
  fprintf( outfile, "<title>Creating room %d</title>\n", room_no );
  fprintf( outfile, "<h1>Creating room %d</h1>\n", room_no );
  fprintf( outfile,
           "<form method=POST action=\"http:%s/textproc\">\n", BINPATH );
  fprintf( outfile, "Describe the scenario:<p>\n" );
  fprintf( outfile, "<input name=\"text\" size=75,10><p>\n" );
  fprintf( outfile, "How many options will the person have? " );
  fprintf( outfile, "<input name=\"numoptions\"><p>\n" );
  if( parent_room ){
    fprintf( outfile, "<a href=\"http:%s/%d.html\"><b>Reject</b></a>",
             RELFILEPATH, parent_room );
    fprintf( outfile, "- Go back to the parent room.<p>\n" );
  }
  fprintf( outfile, "<input type=submit value=\"Accept.\"><p>\n" );
  fprintf( outfile, "<hr>Ignore anything below this line.<p>\n" );
  fprintf( outfile,
           "<input type=hidden name=\"ID\" value=\"%d\"><p>\n",
           room_no );
  fprintf( outfile, "</form>\n" );
  fclose( outfile );
}

/***************************************************************************/

/*
 * $Log: makeroom.C,v $
 * Revision 1.5  1994/07/16  00:04:23  asf
 * Added umask() to set file permissions.
 *
 * Revision 1.4  1994/07/13  19:50:14  asf
 * Added the parent_room parameter.  Added lines to make a "Reject" room
 * link back to the parent room.
 *
 * Revision 1.3  1994/06/05  19:51:20  asf
 * Moved the hidden fields below a line.
 *
 * Revision 1.2  1994/06/05  09:20:47  asf
 * Added GPL
 *
 * Revision 1.1  1994/06/04  22:26:43  asf
 * Initial revision
 *
 */
