/*
 * $Id: makefirst.C,v 1.5 1994/07/16 00:04:03 asf Exp $
 */

/*
    This file is part of Addventure
    Copyright (C) 1994  Allen S. Firstenberg
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Make the initial files required to run Addventure:
 *   1.html    - the first text room
 *   2.html    - the first options entry room
 *   next_room - the number of the next room to be created (3)
 */

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "makeroom.H"

/***************************************************************************/

void make1()
{
  FILE   *f;
  char   filename[160];
  time_t t;

  sprintf( filename, "%s/1.html", ABSFILEPATH );
  
  umask( UMASK );  // Make the files rw-r--r-- or rw-rw-r--
  f = fopen( filename, "w" );
  fprintf( f, "<TITLE>Addventure room 1</TITLE>\n" );
  fprintf( f, "<H1>Addventure room 1</H1>\n" );

  t = time(NULL);
  fprintf( f, "Game started on %s<P>", ctime( &t ) );

  fprintf( f, "Prepare to PLAY! <P>\n" );

  fprintf( f, "<A HREF=\"http:%s/2.html\">Begin</A> <P>\n", RELFILEPATH );

  fclose( f );
}

/***************************************************************************/

void makenr()
{
  FILE *f;
  char filename[160];

  sprintf( filename, "%s/next_room", ABSFILEPATH );

  umask( UMASK );  // Make the files rw-r--r-- or rw-rw-r--
  f = fopen( filename, "w" );

  fprintf( f, "%d\n", 3 );
  
  fclose( f );
}

/***************************************************************************/

main(){
  make1();
  make_room( 2, 1 );
  makenr();
}

/***************************************************************************/

/*
 * $Log: makefirst.C,v $
 * Revision 1.5  1994/07/16  00:04:03  asf
 * Added umask() to set valid file permissions.
 *
 * Revision 1.4  1994/07/13  19:52:41  asf
 * Added parent room 1 to the parameters for make_room()
 *
 * Revision 1.3  1994/06/11  21:18:02  asf
 * Added start time for game on room 1.
 *
 * Revision 1.2  1994/06/05  09:20:21  asf
 * Added GPL
 *
 * Revision 1.1  1994/06/04  22:24:55  asf
 * Initial revision
 *
 */
